/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: PGPsdkFrontEndThread.c,v 1.19.4.1 2001/08/16 17:20:18 pbj Exp $
____________________________________________________________________________*/

#include <process.h>

#include "pgpRMWOLock.h"
#include "pgpErrors.h"
#include "pgpMem.h"
#include "pgpUtilities.h"
#include "pgpContext.h"
#include "pgpRPCMsg.h"
#include "pgpPassCach.h"

static DWORD sThreadId = 0;
static HANDLE sThreadHandle = NULL;
static HANDLE sNotifyEventHandle = NULL;

static int __stdcall
sFrontEndThread(void *vptr)
{
	MSG msg;
	DWORD PGP_WM_SETTIMER = RegisterWindowMessage("PGP_WM_SETTIMER");

	// create an Event synchronization object.  We must use this
	// instead of thread messages to allow notifications to cross
	// sessions under Terminal Services
	sNotifyEventHandle = CreateEvent (NULL, FALSE, FALSE, NULL);

	/*
	 * Force the system to create the Thread Message Queue.
	 */
	PeekMessage(&msg, NULL, WM_USER, WM_USER, PM_NOREMOVE);

	/*
	 * Pull messages off the Thread Message Queue.
	 */
	for (;;) {
		// wait for either the Event object or an incoming message
		DWORD dwReturn = MsgWaitForMultipleObjects (
				1, &sNotifyEventHandle, FALSE, INFINITE, QS_ALLEVENTS);

		if (dwReturn == WAIT_OBJECT_0)
		{
			// the event object was signaled from the backend.
			pgpCallNotificationCallback ();
		}
		else
		{
			// otherwise we have an incoming message.  These
			// messages work under Terminal Services because they
			// always originate from the frontend.
			DWORD n = GetMessage(&msg, (HWND)0, 0, 0);
			if (n == -1) return 0;		// Exits Thread
			switch(msg.message) {
			case WM_QUIT:
				return 0;		// Exits Thread
			case WM_TIMER:		// Timer enabled only when PGPsdkServ is absent.
				{
					PGPContextRef   ctx; 

					ctx = NULL; 
					while( IsntNull( ctx = pgpContextNextContext( ctx ) ) ) 
					{
						pgpExpirePassphraseCache(ctx);
					}
				}
				break;
			default:
				if (msg.message == PGP_WM_SETTIMER) {
					SetTimer((HWND)0, 0, msg.lParam, NULL);
				}
				break;
			}
		}
	}

	CloseHandle (sNotifyEventHandle);

	return 0; // Exits Thread
}

void
pgpInitFrontEndThread(PGPBoolean ClientSidePwdCache)
{
	DWORD n = 0;

	sThreadHandle = (HANDLE)_beginthreadex(
			NULL, 0, sFrontEndThread, NULL,0, &sThreadId);

	// wait for thread to create Event object
	while ((n++ < 5) && (sNotifyEventHandle == NULL))
		Sleep (200);

	/*
	 * ClientSidePwdCache is TRUE only when we are not
	 * running the SDK Service.
	 */
	if (ClientSidePwdCache) {
		pgpSDKFrontEndSetTimer();
	}
}

void
pgpKillFrontEndThread()
{
	DWORD n	= 0;

	// If thread doesn't exist, then we're already done.
	if (sThreadId == 0)
		return;

	// PostThreadMessage could fail if the thread has not yet
	// finished starting up.  Thus, continue to try for a few 
	// seconds.
	while ((n++ < 5) && !PostThreadMessage(sThreadId, WM_QUIT, 0, 0))
		Sleep (1000);

	// If we successfully posted WM_QUIT, then wait (a little 
	// while) for thread to die.  Otherwise just bail out.
	if (n < 5)
		WaitForSingleObject(sThreadHandle, 5000);

	sThreadId = 0;
	sThreadHandle = NULL;
}

void
pgpSDKFrontEndSetTimer()
{
	static DWORD PGP_WM_SETTIMER = 0;
	if (PGP_WM_SETTIMER == 0)
		PGP_WM_SETTIMER = RegisterWindowMessage("PGP_WM_SETTIMER");
	PostThreadMessage(sThreadId, PGP_WM_SETTIMER, 0, 60000);
}

PGPUInt32
pgpSDKGetFrontEndEventHandle() {
	return (PGPUInt32)sNotifyEventHandle;
}

/*
 * pgpNotifyClient -- called by the backend to notify FrontEndThreads
 */
void
pgpNotifyClient(PGPUInt32 connectref, PGPUInt32 lParam)
{
	HANDLE hEvent = (HANDLE)((struct pgpRPCconnection *)connectref)->EventHandle;
	if (hEvent)
		SetEvent (hEvent);
}
